
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using EM = gov.va.med.vbecs.ExceptionManagement;
#endregion

namespace gov.va.med.vbecs.ExceptionManagement.UnitTests
{

	
	

	[TestFixture]
	public class Common_ExceptionManager : BaseTest 
	{
		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}


		/// <summary>
		/// Text to populate the Exception object with
		/// </summary>
		private string ExceptionText
		{
			get
			{
				return("UnitTest" + System.DateTime.Now.ToString());
			}
		}

		[Test]
		public void Publish_Exception_Pass()
		{
			EM.ExceptionManager.Publish(new Exception(this.ExceptionText));
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Publish_Exception_Fail()
		{
		}

		[Test]
		public void Publish_Exception_NameValueCollection_Pass()
		{
			System.Collections.Specialized.NameValueCollection tmpName = new System.Collections.Specialized.NameValueCollection();
			EM.ExceptionManager.Publish(new Exception(this.ExceptionText), tmpName);
			Assert.IsTrue(true);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Publish_Exception_NameValueCollection_Fail()
		{
		}

		[Test]
		public void ConvertExceptionObjectToManagedException_Pass()
		{
			string tmpString = System.DateTime.Now.ToString();

			System.Exception tstValue = ExceptionManager.ConvertExceptionObjectToManagedException(new BOL.BusinessObjectException(tmpString));
			Assert.AreEqual(true, tstValue.Message.Length > 0, "ReturnValue");
		}

		[Test]
		public void ConvertExceptionObjectToManagedException_Fail()
		{
			System.Exception tstValue = ExceptionManager.ConvertExceptionObjectToManagedException(null);
			Assert.AreEqual("Unknown error occurred - exception object is null.", tstValue.Message);
		}
	}

	[TestFixture]
	public class Common_DefaultPublisher : BaseTest
	{

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
		}

		[Test]
		public void Ctor_Blank_Pass()
		{

		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Blank_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_String_String_Fail()
		{
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void Publish_Pass()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Publish_Fail()
		{
		}

		[Test]
		public void FormatExceptionInfoAndDumpToString_Pass()
		{
			string _testMsg = Guid.Empty.ToString();

			try
			{
				throw new InvalidOperationException( _testMsg );
			}
			catch( InvalidOperationException xcp )
			{
				Assert.IsTrue( ExceptionManager.FormatExceptionInfoAndDumpToString( xcp ).IndexOf( _testMsg ) > 0 );
			}
		}

		[Test]
		public void FormatExceptionInfoAndDumpToString_Fail()
		{
            Assert.AreEqual("No exception information available", ExceptionManager.FormatExceptionInfoAndDumpToString(null));
		}
	}

}
#endif


